/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.generator;

import org.apache.poi.generator.RecordUtil;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;

public class FieldIterator {
    protected int offset;

    public void init(XSLProcessorContext context, ElemExtensionCall extElem) {
        this.offset = 0;
    }

    public String fillDecoder(String size, String type) {
        String javaType = RecordUtil.getType(size, type, 0);
        String result = "";
        if (javaType.equals("short")) {
            result = "LittleEndian.getShort(data, pos + 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("short[]")) {
            result = "LittleEndian.getShortArray(data, pos + 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("int")) {
            result = "LittleEndian.getInt(data, pos + 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("byte")) {
            result = "data[ pos + 0x" + Integer.toHexString(this.offset) + " + offset ]";
        } else if (javaType.equals("double")) {
            result = "LittleEndian.getDouble(data, pos + 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("String") && !type.equals("hbstring")) {
            result = "StringUtil.getFromUnicode(data, pos + 0x" + Integer.toHexString(this.offset) + " + offset,(" + size + "-1)/2)";
        } else if (javaType.equals("String") && type.equals("hbstring")) {
            result = "StringUtil.getFromUnicodeHigh(data, pos + 0x" + Integer.toHexString(this.offset) + " + offset, (" + size + "/2))";
        }
        try {
            this.offset += Integer.parseInt(size);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        return result;
    }

    public String fillDecoder2(int position, String name, String size, String type) {
        if (type.startsWith("custom:")) {
            StringBuffer result = new StringBuffer();
            result.append(RecordUtil.getFieldName(position, name, 0));
            result.append(" = new ");
            String javaType = type.substring(7);
            result.append(javaType);
            result.append("();\n");
            result.append("        pos += ");
            result.append(RecordUtil.getFieldName(position, name, 0)).append(".fillField(data,size,pos + offset + ").append(this.offset).append(")");
            return result.toString();
        }
        return RecordUtil.getFieldName(position, name, 30) + " = " + this.fillDecoder(size, type);
    }

    public String serialiseEncoder(int fieldNumber, String fieldName, String size, String type) {
        String javaType = RecordUtil.getType(size, type, 0);
        String javaFieldName = RecordUtil.getFieldName(fieldNumber, fieldName, 0);
        String result = "";
        if (type.startsWith("custom:")) {
            result = "pos += " + javaFieldName + ".serializeField( pos + " + (this.offset + 4) + " + offset, data );";
        } else if (javaType.equals("short")) {
            result = "LittleEndian.putShort(data, " + (this.offset + 4) + " + offset + pos, " + javaFieldName + ");";
        } else if (javaType.equals("short[]")) {
            result = "LittleEndian.putShortArray(data, " + (this.offset + 4) + " + offset + pos, " + javaFieldName + ");";
        } else if (javaType.equals("int")) {
            result = "LittleEndian.putInt(data, " + (this.offset + 4) + " + offset + pos, " + javaFieldName + ");";
        } else if (javaType.equals("byte")) {
            result = "data[ " + (this.offset + 4) + " + offset + pos ] = " + javaFieldName + ";";
        } else if (javaType.equals("double")) {
            result = "LittleEndian.putDouble(data, " + (this.offset + 4) + " + offset + pos, " + javaFieldName + ");";
        } else if (javaType.equals("String") && !type.equals("hbstring")) {
            result = "StringUtil.putUncompressedUnicode(" + javaFieldName + ", data, offset + pos + 4);";
        } else if (javaType.equals("String") && type.equals("hbstring")) {
            result = "StringUtil.putUncompressedUnicodeHigh(" + javaFieldName + ", data, " + (this.offset + 4) + " + offset + pos);";
        }
        try {
            this.offset += Integer.parseInt(size);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        return result;
    }

    public String calcSize(int fieldNumber, String fieldName, String size, String type) {
        String result = " + ";
        if (type.startsWith("custom:")) {
            String javaFieldName = RecordUtil.getFieldName(fieldNumber, fieldName, 0);
            return result + javaFieldName + ".getSize()";
        }
        if ("var".equals(size)) {
            String javaFieldName = RecordUtil.getFieldName(fieldNumber, fieldName, 0);
            return result + " (" + javaFieldName + ".length() *2)";
        }
        if ("varword".equals(size)) {
            String javaFieldName = RecordUtil.getFieldName(fieldNumber, fieldName, 0);
            return result + javaFieldName + ".length * 2 + 2";
        }
        return result + size;
    }
}

